using BepInEx;
using BepInEx.Configuration;
using BepInEx.Logging;
using HarmonyLib;

namespace AaeroResolutionUnlocker;

[BepInPlugin(PluginInfo.PluginGUID, PluginInfo.PluginName, PluginInfo.PluginVersion)]
[BepInProcess("Aaero.exe")]
public class Plugin : BaseUnityPlugin
{
    public static Plugin Instance;
    internal new static ManualLogSource Logger;
    
    // Config entries
    public static ConfigEntry<int> ConfigWidth;
    public static ConfigEntry<int> ConfigHeight;
    public static ConfigEntry<bool> ConfigFullscreen;
    
    public void Awake()
    {
        Instance = this;
        Logger = base.Logger;
        
        // Create config entries
        ConfigWidth = Config.Bind("Resolution", "Width", 1920, 
            "Screen width resolution");
        ConfigHeight = Config.Bind("Resolution", "Height", 1080, 
            "Screen height resolution");
        ConfigFullscreen = Config.Bind("Resolution", "Fullscreen", true, 
            "Whether to run in fullscreen mode");
        
        Logger.LogInfo($"Plugin {PluginInfo.PluginGUID} is loaded!");
        Logger.LogInfo($"Configured resolution: {ConfigWidth.Value}x{ConfigHeight.Value}, Fullscreen: {ConfigFullscreen.Value}");
        
        var harmony = new Harmony($"{PluginInfo.PluginGUID}");
        harmony.PatchAll(typeof(ResolutionUnlocker));
    }
}